<?php use App\Enums\TxnStatus; ?>

<?php $__env->startSection('title'); ?>
<?php echo e(__('Schema Logs')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-xl-12 desktop-screen-show">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('All Invested Schemas')); ?></h3>
            </div>
            <div class="site-card-body">
                <div class="site-table">
                    <div class="table-filter">
                        <div class="filter">
                            <form action="<?php echo e(route('user.invest-logs')); ?>" method="get">
                                <div class="search">
                                    <input type="text" id="search" placeholder="Search" value="<?php echo e(request('query')); ?>"
                                        name="query" />
                                    <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>" />
                                    <button type="submit" class="apply-btn"><i
                                            icon-name="search"></i><?php echo e(__('Search')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php
                    $logs = $data->when(request('query'),function($query){
                    $query->whereHas('schema',function($schemaQuery){
                    $schemaQuery->where('name','LIKE','%'.request('query').'%');
                    });
                    })->paginate(request()->integer('limit',15))->withQueryString();
                    ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Icon</th>
                                    <th><?php echo e(__('Schema')); ?></th>
                                    <th><?php echo e(__('ROI')); ?></th>
                                    <th><?php echo e(__('Period Remaining')); ?></th>
                                    <th><?php echo e(__('Profit')); ?></th>
                                    <th><?php echo e(__('Capital Back')); ?></th>
                                    <th><?php echo e(__('Timeline')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <img class="schema-icon" src="<?php echo e(asset($invest->schema->icon)); ?> " alt="">
                                    </td>
                                    <td>
                                        <div class="content">
                                            <h6 class="title  gradient-text-1 fw-7"><?php echo e($invest->schema->name); ?> >
                                                <?php echo e($currencySymbol.$invest->invest_amount); ?></h6>
                                            <p class="description"><?php echo e($invest->created_at); ?></p>
                                        </div>
                                    </td>
                                    <td><strong><?php echo e($invest->interest_type == 'percentage' ? $invest->interest.'%' : $currencySymbol.$invest->interest); ?></strong>
                                    </td>
                                    <td><strong><?php echo e($invest->return_type != 'period' ? __('Unlimited') : $invest->number_of_period . ($invest->number_of_period < 2 ? ' Time' : ' Times')); ?></strong>
                                    </td>

                                    <?php
                                    $calculateInterest = ($invest->interest*$invest->invest_amount)/100;
                                    $interest = $invest->interest_type != 'percentage' ? $invest->interest :
                                    $calculateInterest;
                                    ?>
                                    <td><strong
                                            class=""><?php echo e($invest->already_return_profit .' x '.$interest .' = '. ($invest->already_return_profit*$interest).' '. $currency); ?></strong>
                                    </td>
                                    <td>
                                        <div class="site-badge primary-bg">
                                            <?php echo e($invest->capital_back ? 'Yes' : 'No'); ?>

                                        </div>
                                    </td>
                                    <td><strong><?php if($invest->status->value == 'ongoing'): ?>
                                            <div class="timeline-grid">
                                                <span class="white-text">
                                                    <span id="days<?php echo e($invest->id); ?>"></span>D : <span
                                                        id="hours<?php echo e($invest->id); ?>"></span>H : <span
                                                        id="minutes<?php echo e($invest->id); ?>"></span>M : <span
                                                        id="seconds<?php echo e($invest->id); ?>"></span>S
                                                </span>
                                                <div class="single-progress">
                                                    <div class="progress">
                                                        <div class="progress-bar" id="time-progress<?php echo e($invest->id); ?>"
                                                            role="progressbar" style="width: 100%;" aria-valuenow="47"
                                                            aria-valuemin="0" aria-valuemax="100">
                                                        </div>
                                                    </div>
                                                </div>
                                                <span class="white-text" id="percent-text<?php echo e($invest->id); ?>">100%</span>
                                            </div>
                                            <script>
                                                (function ($) {
                                                    "use strict";
                                                    // Countdown
                                                    const second = 1000,
                                                        minute = second * 60,
                                                        hour = minute * 60,
                                                        day = hour * 24;
                                                    let timezone = <?php echo json_encode(setting('site_timezone', 'global'), 512) ?>;


                                                    let countDown = new Date('<?php echo e($invest->next_profit_time); ?>')
                                                        .getTime()
                                                    var start = new Date(
                                                            '<?php echo e($invest->last_profit_time ?? $invest->created_at); ?>')
                                                        .getTime()
                                                    setInterval(function () {

                                                        let utc_datetime_str = new Date().toLocaleString(
                                                            "en-US", {
                                                                timeZone: timezone
                                                            });
                                                        let now = new Date(utc_datetime_str).getTime();

                                                        let distance = countDown - now;


                                                        var progress = (((now - start) / (countDown -
                                                            start)) * 100).toFixed(2);


                                                        $("#time-progress<?php echo e($invest->id); ?>").css("width",
                                                            progress + '%');

                                                        $("#percentage<?php echo e($invest->id); ?>").text(progress >=
                                                            100 ? 100 + '%' : progress + '%');
                                                        $('#percent-text<?php echo e($invest->id); ?>').text(progress >=
                                                            100 ? 100 + '%' : progress + '%')

                                                        document.getElementById('days<?php echo e($invest->id); ?>')
                                                            .innerText = Math.floor(distance < 0 ? 0 :
                                                                distance / (day)),
                                                            document.getElementById(
                                                                'hours<?php echo e($invest->id); ?>').innerText = Math
                                                            .floor(distance < 0 ? 0 : (distance % (day)) / (
                                                                hour)),
                                                            document.getElementById(
                                                                'minutes<?php echo e($invest->id); ?>').innerText = Math
                                                            .floor(distance < 0 ? 0 : (distance % (hour)) /
                                                                (minute)),
                                                            document.getElementById(
                                                                'seconds<?php echo e($invest->id); ?>').innerText = Math
                                                            .floor(distance < 0 ? 0 : (distance % (
                                                                minute)) / second);

                                                    }, second)

                                                })(jQuery)

                                            </script>
                                            <?php elseif($invest->status->value == 'pending'): ?>
                                            <span class="site-badge warnning"><?php echo e(__('Pending')); ?></span>
                                            <?php elseif($invest->status->value == 'completed'): ?>
                                            <div class="d-flex gap-10">
                                                <span class="site-badge success"><?php echo e(__('Success')); ?></span>
                                            </div>
                                            <?php else: ?>
                                            <span class="site-badge primary-bg"><?php echo e(__('Cancelled')); ?></span>
                                            <?php endif; ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <?php if($invest->schema->schema_cancel &&
                                             ($invest->status->value !== 'canceled') &&
                                             now()->diffInMinutes($invest->created_at) <= $invest->schema->expiry_minute): ?>
                                            <form action="<?php echo e(route('user.invest-cancel', $invest->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="site-badge primary-bg"><?php echo e(__('Cancel')); ?></button>
                                            </form>
                                        <?php else: ?>
                                            --
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php if(count($logs) == 0): ?>
                            <div class="alert alert-table mt-20 text-center" role="alert">
                                <?php echo e(__('No Data Found')); ?>

                            </div>
                            <?php endif; ?>
                        </table>
                        <?php echo e($logs->links('frontend::include.__pagination')); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="col-12 mobile-screen-show">
        <div class="all-feature-mobile mobile-transactions mb-3">
            <div class="title"><?php echo e(__('All Schemas')); ?></div>
            <div class="mobile-transaction-filter">
                <div class="filter">
                    <form action="<?php echo e(route('user.invest-logs')); ?>" method="get">
                        <div class="search">

                            <input type="text" placeholder="Search" value="<?php echo e(request('query')); ?>" name="query" />
                            <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>" />
                            <button type="submit" class="apply-btn"><i icon-name="search"></i></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="contents">
                <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="single-transaction">
                    <div class="transaction-left">
                        <div class="transaction-des">
                            <h4 class="title gradient-text-1 fw-7"><?php echo e($invest->schema->name); ?> >>
                                <?php echo e($currencySymbol.$invest->invest_amount); ?></h4>
                            <p class="description"><?php echo e($invest->created_at); ?></p>
                        </div>
                    </div>
                    <div class="transaction-right">
                        <div class="transaction-amount ">
                            <?php echo e($invest->interest_type == 'percentage' ? $invest->interest.'%' : $currencySymbol.$invest->interest); ?>

                        </div>
                        <div class="transaction-fee sub">
                            <?php
                            $calculateInterest = ($invest->interest*$invest->invest_amount)/100;
                            $interest = $invest->interest_type != 'percentage' ? $invest->interest : $calculateInterest;
                            ?>
                        </div>
                        <div class="transaction-gateway">
                            <?php echo e($invest->already_return_profit .' x '.$interest .' = '. ($invest->already_return_profit*$interest).' '. $currency); ?>

                        </div>
                        <div class="site-table-col">
                            <span
                                class="white-text"><?php echo e($invest->return_type != 'period' ? __('Unlimited') : $invest->number_of_period . ($invest->number_of_period < 2 ? ' Time' : ' Times')); ?></span>
                        </div>
                        <div class="site-table-col">
                            <span class="success-text"><?php echo e($invest->capital_back ? 'Yes' : 'No'); ?></span>
                        </div>
                        <div class="site-table-col">
                            <?php if($invest->status->value == 'ongoing'): ?>
                            <div class="timeline-grid">
                                <span class="white-text">
                                    <span id="mobile-days<?php echo e($invest->id); ?>"></span>D : <span
                                        id="mobile-hours<?php echo e($invest->id); ?>"></span>H : <span
                                        id="mobile-minutes<?php echo e($invest->id); ?>"></span>M : <span
                                        id="mobile-seconds<?php echo e($invest->id); ?>"></span>S
                                </span>
                                <div class="single-progress">
                                    <div class="progress">
                                        <div class="progress-bar" id="mobile-time-progress<?php echo e($invest->id); ?>" role="progressbar"
                                            style="width: 100%;" aria-valuenow="47" aria-valuemin="0"
                                            aria-valuemax="100">
                                        </div>
                                    </div>
                                </div>
                                <span class="white-text" id="mobile-percent-text<?php echo e($invest->id); ?>">100%</span>
                            </div>
                            <script>
                                (function ($) {
                                    "use strict";
                                    // Countdown
                                    const second = 1000,
                                        minute = second * 60,
                                        hour = minute * 60,
                                        day = hour * 24;
                                    let timezone = <?php echo json_encode(setting('site_timezone', 'global'), 512) ?>;


                                    let countDown = new Date('<?php echo e($invest->next_profit_time); ?>').getTime()
                                    var start = new Date('<?php echo e($invest->last_profit_time ?? $invest->created_at); ?>')
                                        .getTime()
                                    setInterval(function () {

                                        let utc_datetime_str = new Date().toLocaleString("en-US", {
                                            timeZone: timezone
                                        });
                                        let now = new Date(utc_datetime_str).getTime();

                                        let distance = countDown - now;

                                        var progress = (((now - start) / (countDown - start)) * 100)
                                            .toFixed(2);

                                        $("#mobile-time-progress<?php echo e($invest->id); ?>").css("width", progress + '%');

                                        $("#mobile-percentage<?php echo e($invest->id); ?>").text(progress >= 100 ? 100 + '%' :
                                            progress + '%');
                                        $('#mobile-percent-text<?php echo e($invest->id); ?>').text(progress >= 100 ? 100 +
                                            '%' : progress + '%')

                                        document.getElementById('mobile-days<?php echo e($invest->id); ?>').innerText = Math
                                            .floor(distance < 0 ? 0 : distance / (day)),
                                            document.getElementById('mobile-hours<?php echo e($invest->id); ?>').innerText =
                                            Math.floor(distance < 0 ? 0 : (distance % (day)) / (hour)),
                                            document.getElementById('mobile-minutes<?php echo e($invest->id); ?>').innerText =
                                            Math.floor(distance < 0 ? 0 : (distance % (hour)) / (minute)),
                                            document.getElementById('mobile-seconds<?php echo e($invest->id); ?>').innerText =
                                            Math.floor(distance < 0 ? 0 : (distance % (minute)) / second);

                                    }, second)

                                })(jQuery)

                            </script>
                            <?php elseif($invest->status->value == 'pending'): ?>
                            <span class="site-badge warnning"><?php echo e(__('Pending')); ?></span>
                            <?php elseif($invest->status->value == 'completed'): ?>
                            <span class="site-badge success"><?php echo e(__('Success')); ?></span>
                            <?php else: ?>
                            <span class="site-badge primary-bg"><?php echo e(__('Cancelled')); ?></span>
                            <?php endif; ?>
                        </div>
                        <?php if($invest->schema->schema_cancel &&
                                             ($invest->status->value !== 'canceled') &&
                                             now()->diffInMinutes($invest->created_at) <= $invest->schema->expiry_minute): ?>
                            <form action="<?php echo e(route('user.invest-cancel', $invest->id)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="site-badge primary-bg"><?php echo e(__('Cancel')); ?></button>
                            </form>
                        <?php else: ?>
                            --
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sharjkhh/public_html/app/Providers/../../resources/views/frontend/default/user/invest/log.blade.php ENDPATH**/ ?>