
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Referral URL')); ?> <?php if(setting('site_referral','global') == 'level'): ?>
                            <?php echo e(__('and Tree')); ?>

                        <?php endif; ?></h3>
                </div>
                <div class="site-card-body">
                    <div class="referral-link">
                        <div class="referral-link-form">
                            <input type="text" value="<?php echo e($getReferral->link); ?>" id="refLink"/>
                            <button type="submit" onclick="copyRef()">
                                <i class="anticon anticon-copy"></i>
                                <span id="copy"><?php echo e(__('Copy Url')); ?></span>
                                <input id="copied" hidden value="<?php echo e(__('Copied')); ?>">
                            </button>
                        </div>
                        <p class="referral-joined">
                            <?php echo e($getReferral->relationships()->count()); ?> <?php echo e(__('peoples are joined by using this URL')); ?>

                        </p>
                    </div>

                    
                    <?php if(setting('site_referral','global') == 'level' && auth()->user()->referrals->count() > 0): ?>
                        <section class="management-hierarchy">
                            <div class="hv-container">
                                <div class="hv-wrapper">
                                    <!-- tree component -->
                                    <?php echo $__env->make('frontend::referral.include.__tree',['levelUser' => auth()->user(),'level' => $level,'depth' => 1, 'me' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </section>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('All Referral Logs')); ?></h3>
                    <div class="card-header-links">
                        <span
                            class="card-header-link rounded-pill"> <?php echo e(__('Referral Profit:').' '. $totalReferralProfit .' '.$currency); ?></span>
                    </div>
                </div>
                <div class="site-card-body table-responsive">


                    <div class="site-tab-bars">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a
                                    href=""
                                    class="nav-link active"
                                    id="generalTarget-tab"
                                    data-bs-toggle="pill"
                                    data-bs-target="#generalTarget"
                                    type="button"
                                    role="tab"
                                    aria-controls="generalTarget"
                                    aria-selected="true"
                                ><i icon-name="network"></i><?php echo e(__('General')); ?></a>
                            </li>

                            <?php $__currentLoopData = $referrals->keys(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php
                                    $target = json_decode($raw,true);
                                ?>

                                <li class="nav-item" role="presentation">
                                    <a
                                        href=""
                                        class="nav-link"
                                        id="t<?php echo e($target['id']); ?>-tab"
                                        data-bs-toggle="pill"
                                        data-bs-target="#t<?php echo e($target['id']); ?>"
                                        type="button"
                                        role="tab"
                                        aria-controls="t<?php echo e($target['id']); ?>"
                                        aria-selected="true"
                                    ><i icon-name="boxes"></i>
                                        <?php if(setting('site_referral','global') == 'level'): ?>
                                            Level <?php echo e($target['the_order']); ?>

                                        <?php else: ?>
                                            <?php echo e($target['name']); ?>

                                        <?php endif; ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>


                    <div class="tab-content" id="pills-tabContent">

                        <div
                            class="tab-pane fade show active"
                            id="generalTarget"
                            role="tabpanel"
                            aria-labelledby="generalTarget-tab"
                        >

                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 desktop-screen-show">
                                    <div class="site-datatable">
                                        <div class="row table-responsive">
                                            <div class="col-xl-12">
                                                <table class="display data-table">
                                                    <thead>
                                                    <tr>
                                                        <th><?php echo e(__('Description')); ?></th>
                                                        <th><?php echo e(__('Transactions ID')); ?></th>
                                                        <th><?php echo e(__('Amount')); ?></th>
                                                        <th><?php echo e(__('Status')); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>


                                                    <?php $__currentLoopData = $generalReferrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td>
                                                                <div class="table-description">
                                                                    <div class="icon">
                                                                        <i icon-name="arrow-down-left"></i>
                                                                    </div>
                                                                    <div class="description">
                                                                        <strong><?php echo e($raw->description); ?></strong>
                                                                        <div
                                                                            class="date"><?php echo e($raw->created_at); ?></div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td><strong><?php echo e($raw->tnx); ?></strong></td>
                                                            <td><strong
                                                                    class="green-color">+<?php echo e($raw->amount.' '. $currency); ?> </strong>
                                                            </td>
                                                            <td>
                                                                <div
                                                                    class="site-badge success"><?php echo e($raw->status); ?></div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                    </tbody>
                                                </table>

                                                <?php if($generalReferrals->isEmpty()): ?>
                                                    <p class="centered"><?php echo e(__('No Data Found')); ?></p>
                                                <?php endif; ?>

                                                <?php echo e($generalReferrals->links()); ?>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-12 mobile-screen-show">
                                    <!-- Transactions -->
                                    <div class="all-feature-mobile mobile-transactions mb-3">
                                        <div class="contents">
                                            <?php $__currentLoopData = $generalReferrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="single-transaction">
                                                    <div class="transaction-left">
                                                        <div class="transaction-des">
                                                            <div
                                                                class="transaction-title"><?php echo e($raw->description); ?></div>
                                                            <div class="transaction-id"><?php echo e($raw->tnx); ?></div>
                                                            <div
                                                                class="transaction-date"><?php echo e($raw->created_at); ?></div>
                                                        </div>
                                                    </div>
                                                    <div class="transaction-right">
                                                        <div
                                                            class="transaction-amount add">
                                                            + <?php echo e($raw->amount .' '.$currency); ?></div>
                                                        <div class="transaction-gateway"><?php echo e($raw->method); ?></div>

                                                        <?php if($raw->status->value == App\Enums\TxnStatus::Pending->value): ?>
                                                            <div
                                                                class="transaction-status pending"><?php echo e(__('Pending')); ?></div>
                                                        <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Success->value): ?>
                                                            <div
                                                                class="transaction-status success"><?php echo e(__('Success')); ?></div>
                                                        <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Failed->value): ?>
                                                            <div
                                                                class="transaction-status canceled"><?php echo e(__('Canceled')); ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php echo e($generalReferrals->onEachSide(1)->links()); ?>

                                    </div>

                                </div>
                            </div>


                        </div>

                        <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target => $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $target = json_decode($target,true);
                            ?>

                            <div
                                class="tab-pane fade"
                                id="t<?php echo e($target['id']); ?>"
                                role="tabpanel"
                                aria-labelledby="t<?php echo e($target['id']); ?>-tab"
                            >
                                <div class="row">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 desktop-screen-show">
                                        <div class="site-datatable">
                                            <div class="row table-responsive">
                                                <div class="col-xl-12">
                                                    <table class="display data-table">
                                                        <thead>
                                                        <tr>
                                                            <th><?php echo e(__('Description')); ?></th>
                                                            <th><?php echo e(__('Transactions ID')); ?></th>
                                                            <th><?php echo e(__('Type')); ?></th>
                                                            <th><?php echo e(__('Amount')); ?></th>
                                                            <th><?php echo e(__('Status')); ?></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        <?php $__currentLoopData = $referral->sortDesc(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td>
                                                                    <div class="table-description">
                                                                        <div class="icon">
                                                                            <i icon-name="arrow-down-left"></i>
                                                                        </div>
                                                                        <div class="description">
                                                                            <strong><?php echo e($raw->description); ?></strong>
                                                                            <div
                                                                                class="date"><?php echo e($raw->created_at); ?></div>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td><strong><?php echo e($raw->tnx); ?></strong></td>
                                                                <td>
                                                                    <div
                                                                        class="site-badge primary-bg"><?php echo e($raw->target_type); ?></div>
                                                                </td>
                                                                <td><strong
                                                                        class="green-color">+<?php echo e($raw->amount.' '. $currency); ?> </strong>
                                                                </td>
                                                                <td>
                                                                    <div
                                                                        class="site-badge success"><?php echo e($raw->status); ?></div>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 mobile-screen-show">
                                        <!-- Transactions -->
                                        <div class="all-feature-mobile mobile-transactions mb-3">
                                            <div class="contents">
                                                <?php $__currentLoopData = $referral->sortDesc(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="single-transaction">
                                                        <div class="transaction-left">
                                                            <div class="transaction-des">
                                                                <div
                                                                    class="transaction-title"><?php echo e($raw->description); ?>

                                                                </div>
                                                                <div class="transaction-id"><?php echo e($raw->tnx); ?></div>
                                                                <div
                                                                    class="transaction-date"><?php echo e($raw->created_at); ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="transaction-right">
                                                            <div
                                                                class="transaction-amount add">
                                                                +<?php echo e($raw->amount .' '.$currency); ?></div>
                                                            <div
                                                                class="transaction-gateway"> <?php echo e($raw->target_type); ?></div>

                                                            <?php if($raw->status->value == App\Enums\TxnStatus::Pending->value): ?>
                                                                <div
                                                                    class="transaction-status pending"><?php echo e(__('Pending')); ?></div>
                                                            <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Success->value): ?>
                                                                <div
                                                                    class="transaction-status success"><?php echo e(__('Success')); ?></div>
                                                            <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Failed->value): ?>
                                                                <div
                                                                    class="transaction-status canceled"><?php echo e(__('canceled')); ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>

                                    </div>
                                </div>


                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function copyRef() {
            /* Get the text field */
            var copyApi = document.getElementById("refLink");
            /* Select the text field */
            copyApi.select();
            copyApi.setSelectionRange(0, 999999999); /* For mobile devices */
            /* Copy the text inside the text field */
            document.execCommand('copy');
            $('#copy').text($('#copied').val())
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sharjkhh/public_html/app/Providers/../../resources/views/frontend/default/referral/index.blade.php ENDPATH**/ ?>