<div class="tab-pane fade <?php echo e(request()->get('tab') === 'earnings' ? 'show active' : ''); ?>" id="pills-deposit" role="tabpanel" aria-labelledby="pills-deposit-tab">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Earnings')); ?></h4>
                    <div class="card-header-info"><?php echo e(__('Total Earnings:')); ?> <?php echo e($user->totalProfit()); ?> <?php echo e($currency); ?></div>
                </div>
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="site-table table-responsive">
                                <form action="<?php echo e(request()->url()); ?>" method="get">
                                    <div class="table-filter">
                                        <div class="filter">
                                        </div>
                                    <!-- <div class="filter d-flex">
                                            <div class="search">
                                                <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                            </div>
                                            <button type="submit" class="apply-btn"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                                        </div> -->
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Date')); ?></th>
                                        <th scope="col"><?php echo e(__('User')); ?></th>
                                        <th scope="col"><?php echo e(__('Amount')); ?></th>
                                        <th scope="col"><?php echo e(__('Type')); ?></th>
                                        <th scope="col"><?php echo e(__('Profit From')); ?></th>
                                        <th scope="col"><?php echo e(__('Description')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item->created_at); ?></td>
                                            <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                            <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                            <td><?php echo $__env->make('backend.transaction.include.__txn_type', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                            <td><?php echo e($item->from_user_id != null ? \App\Models\User::find($item->from_user_id)->username : 'System'); ?></td>
                                            <td><?php echo e($item->description); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <?php if($data->isEmpty()): ?>
                                    <p><?php echo e(__('No Earnings found.')); ?></p>
                                <?php endif; ?>
                                <?php echo e($data->links('backend.include.__pagination')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('single-script'); ?>
    <script>
        (function($) {
            "use strict";

            var table = $('#user-profit-dataTable').DataTable({
                processing: true,
                serverSide: true,
                autoWidth: false,
                ajax: "<?php echo e(route('admin.all-profits',$user->id)); ?>",
                columns: [{
                    data: 'created_at',
                    name: 'created_at'
                },
                    {
                        data: 'final_amount',
                        name: 'final_amount'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'profit_from',
                        name: 'profit_from'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },

                ]
            });


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/sharjkhh/public_html/resources/views/backend/user/include/__earnings.blade.php ENDPATH**/ ?>