
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Pending Withdraws')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('withdraw_content'); ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="site-table table-responsive">
                    <form action="<?php echo e(request()->url()); ?>" method="get">
                        <div class="table-filter d-flex justify-content-between">
                            <div class="filter d-flex">
                                <div class="search">
                                    <input type="text" id="search" name="query" value="<?php echo e(request('query')); ?>" placeholder="Search" />
                                </div>
                                <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i><?php echo e(__('Search')); ?></button>
                            </div>
                        </div>
                    </form>
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Transaction ID')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Charge')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $pendings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pending): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <tr>
                                <td><?php echo e($pending->created_at); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__user', ['item' => $pending], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($pending->tnx); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['item' => $pending], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($pending->charge . ' ' . setting('site_currency', 'global')); ?></td>
                                <td><?php echo e($pending->method); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_status', ['status' => $pending->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo $__env->make('backend.withdraw.include.__action', ['item' => $pending], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    <?php echo e($pendings->links('backend.include.__pagination')); ?>

                </div>
            </div>
        </div>
    </div>
    <!-- Modal for Pending Deposit Approval -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-action')): ?>
        <div class="modal fade" id="deposit-action-modal" tabindex="-1" aria-labelledby="editPendingDepositModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content site-table-modal">
                    <div class="modal-body popup-body">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="popup-body-text withdraw-action">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Modal for Pending Deposit Approval -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        (function($) {
            "use strict";

            //send mail modal form open
            $('body').on('click', '#withdrawActionBtn', function() {
 
                var id = $(this).data('id');
                var url = '<?php echo e(route("admin.withdraw.action",":id")); ?>';
                url = url.replace(':id', id);
                $.get(url, function(data) {
                    $('.withdraw-action').html(data)
                    imagePreview()
                })
                $('#deposit-action-modal').modal('toggle')

            });

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.withdraw.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sharjkhh/public_html/resources/views/backend/withdraw/pending.blade.php ENDPATH**/ ?>