<div class="tab-pane fade <?php echo e(request()->get('tab') === 'transactions' ? 'show active' : ''); ?>" id="pills-transactions" role="tabpanel" aria-labelledby="pills-transactions-tab">
    <div class="site-card">
        <div class="site-card-header">
            <h3 class="title"><?php echo e(__('Transactions')); ?></h3>
        </div>
        <div class="site-card-body table-responsive">
            <form action="<?php echo e(request()->url()); ?>" method="get">
                <div class="site-datatable">
                    <table id="dataTable" class="display data-table">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Transaction ID')); ?></th>
                            <th><?php echo e(__('Type')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($item->created_at); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__user', ['user' => $item->user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($item->tnx); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_type', ['type' => $item->type], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_amount', ['amount' => $item->final_amount], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                                <td><?php echo e($item->method); ?></td>
                                <td><?php echo $__env->make('backend.transaction.include.__txn_status', ['status' => $item->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php if($data->isEmpty()): ?>
                        <p><?php echo e(__('No Transaction found.')); ?></p>
                    <?php endif; ?>
                    <?php echo e($data->links('backend.include.__pagination')); ?>

                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH /home/sharjkhh/public_html/resources/views/backend/user/include/__transactions.blade.php ENDPATH**/ ?>