@extends('frontend::pages.index')
@section('title')
{{ $data['title'] }}
@endsection
@section('meta_keywords')
{{ $data['meta_keywords'] }}
@endsection
@section('meta_description')
{{ $data['meta_description'] }}
@endsection
@section('page-content')
@php
$rankings = \App\Models\Ranking::where('status',true)->get()
@endphp

<!-- Rankings section start -->
<div class="rankings-srcion section-space-top fix">
    <div class="container">
        <div class="row gy-50 align-items-center">
            @foreach($rankings as $ranking)
            <div class="col-xxl-3 col-xl-3 col-xl-4 col-lg-4 col-md-6">
                <div class="rankings-badge-item">
                    <div class="rankings-badge-inner">
                        <div class="rankings-badge-icon">
                            <span><img src="{{ asset($ranking->icon) }}" alt="rankings-badge"></span>
                        </div>
                        <div class="rankings-badge-content">
                            <h3 class="title">{{ $ranking->ranking_name }}</h3>
                            <p class="description">{{ $ranking->description }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
<!-- Rankings section end -->
@include('frontend::home.include.__newsletter')
@endsection