@extends('frontend::pages.index')
@section('title')
{{ $blog->title }}
@endsection
@section('page-content')
<!-- Postbox details area start -->
<section class="coinefy-postbox-details-area position-relative fix section-space-top">
   <div class="container">
      <div class="row g-40">
         <div class="col-xxl-8 col-xl-7 col-lg-7">
            <div class="postbox-wrapper">
               <div class="postbox-item mb-20">
                  <div class="postbox-title">
                     <h3 class="title">{{ $blog->title }}</h3>
                  </div>
               </div>
               <div class="postbox-item mb-45">
                  <div class="postbox-thumb">
                     <img src="{{ asset($blog->cover) }}" alt="postbox image not found">
                  </div>
               </div>
               <div class="postbox-item mb-45">
                  <div class="postbox-text">
                     <p class="mb-3"> {!! $blog->details !!}
                     </p>
                  </div>

               </div>

            </div>
         </div>
         <div class="col-xxl-4 col-xl-5 col-lg-5">

            <div class="sidebar-wrapper mb-45">
               <div class="sidebar-widget">
                  <h3 class="sidebar-widget-title">{{ $data['sidebar_widget_title'] }}</h3>
                  <div class="sidebar-widget-content">
                     <div class="sidebar-post">
                        @foreach($blogs as $id => $recent)
                        <a href="{{ route('blog-details',$recent->id) }}" class=" rc-post-item">
                           <div class="rc-post-thumb">
                              <img src="{{ asset($recent->cover) }}" alt="image not found">
                           </div>
                           <div class="rc-post-content">
                              <h5 class="rc-post-title">
                                 {{ $recent->title }}
                              </h5>
                              <div class="rc-meta">
                                 <p>{{ Str::limit(strip_tags($recent->details),35)   }}</p>
                              </div>
                           </div>
                        </a>
                        @endforeach
                     </div>
                  </div>
               </div>
            </div>

         </div>
      </div>
   </div>
</section>
<!-- Postbox details area end -->
@include('frontend::home.include.__newsletter')
@endsection