@php
$landingContent = \App\Models\LandingContent::where('type','howitworks')->where('locale',app()->getLocale())->get();

@endphp

<div class="big-doller-wrapper p-relative fix z-index-11">
    <div class="big-dollar-shape">
        <img src="{{ asset('frontend/theme_base/coinefy/images/shapes/big-doller-coins.png')}}" alt="coins">
    </div>
    <section class="how-it-work-section">
        <div class="container">
            <div class="how-it-work-main" data-background="{{ asset('frontend/theme_base/coinefy/images/bg/how-it-work-bg.png')}}">
                <div class="row">
                    <div class="col-xxl-6 col-xl-6">
                        <div class="section-heading section-title-space">
                            <span class="section-subtitle">{{ $data['title_small'] }}</span>
                            <h2 class="section-title">{{ $data['title_big'] }}</h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="how-it-work-grid">
                            @foreach($landingContent as $content)
                            <div class="how-it-works-item">
                                <div class="icon">
                                    <span>
                                        <img src="{{ asset($content->icon) }}" alt="works icon">
                                    </span>
                                </div>
                                <div class="content">
                                    <h3 class="title">{{ $content->title }}</h3>
                                    <p class="description">{{ $content->description }}</p>
                                </div>
                                <div class="step">
                                    <span class="arrow"></span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>