@extends('frontend::layouts.auth')

@section('title')
{{ __('Register') }}
@endsection
@section('content')

<!-- Sign up area start -->
<div class="sign-up-area">
    <div class="auth-inner">
        <div class="auth-wrapper sing-up">
            <div class="auth-from-inner">
                <div class="auth-from-top-content">
                    <div class="auth-logo">
                        <a href="{{ route('home') }}">
                            <img src="{{ asset(setting('site_logo','global')) }}" alt="logo">
                        </a>
                    </div>
                    <h3 class="title">{{ $data['title'] }}</h3>
                    <p class="description">{{ $data['bottom_text'] }}</p>
                </div>
                <div class="auth-from-box">
                    @if ($errors->any())
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        @foreach($errors->all() as $error)
                        <strong>{{ $error }}</strong>
                        @endforeach
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <form action="{{ route('register') }}" id="signUpForm" method="POST">
                        @csrf
                        <div class="row g-24">
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="text" name="first_name" class="box-input" placeholder="{{ __('First Name') }}" required value="{{ old('first_name') }}">
                                        <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                </div>
                            </div>
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="text" name="last_name" class="box-input" placeholder="{{__('Last Name')}}" required value="{{ old('last_name') }}">
                                        <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                </div>
                            </div>
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="email" name="email" class="box-input" placeholder="{{ __('Email Address') }}" required value="{{ old('email') }}">
                                        <span class="input-icon"><i class="fa-light fa-envelope-open"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                </div>
                            </div>
                            @if(getPageSetting('username_show'))
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="text" name="username" class="box-input" placeholder="{{ __('Username') }}" required value="{{ old('username') }}">
                                        <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                </div>
                            </div>
                            @endif
                            @if(getPageSetting('country_show'))
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input">
                                    <div class="coinefy-input-filter">
                                        <select name="country" id="countrySelect">
                                            @foreach( getCountries() as $country)
                                            <option @if( $location->country_code == $country['code']) selected
                                                @endif value="{{ $country['name'].':'.$country['dial_code'] }}">
                                                {{ $country['name']  }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            @endif
                            @if(getPageSetting('phone_show'))
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input">
                                    <div class="input-field input-group">
                                        <span class="input-group-text" id="dial-code">{{ getLocation()->dial_code }}</span>
                                        <input type="text" name="phone" placeholder="{{ __('Phone Number') }}" value="{{ old('phone') }}">
                                    </div>
                                </div>
                            </div>
                            @endif
                            @if(getPageSetting('referral_code_show'))
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="text" name="invite" class="box-input" placeholder="{{ __('Referral Code') }}" value="{{ request('invite') ?? old('invite') }}">
                                        <span class="input-icon"><i class="fa-regular fa-users"></i></span>
                                    </div>
                                    
                                </div>
                            </div>
                            @endif
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="password" name="password" class="box-input password-input" id="new-password" placeholder="{{ __('Password') }}" required>
                                        <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                </div>
                            </div>
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="coinefy-single-input has-right-icon">
                                    <div class="input-field">
                                        <input type="password" name="password_confirmation" class="box-input password-input" id="confirm-password" placeholder="{{ __('Confirm Password') }}" required>
                                        <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                                    </div>
                                    <p class="feedback-invalid">This field is required</p>
                                    <!-- <p class="input-description">Must be at least eight character (1 uppercase, 1 lowercase letter, 1 number and 1 special character)</p> -->
                                </div>
                            </div>
                            @if($googleReCaptcha)
                            <div class="g-recaptcha" id="feedback-recaptcha" data-sitekey="{{ json_decode($googleReCaptcha->data,true)['google_recaptcha_key'] }}">
                            </div>
                            @endif
                            <div class="col-xxl-12">
                                <div class="animate-custom">
                                    <input class="inp-cbx" name="i_agree" id="auth_remind" value="yes" type="checkbox" style="display: none;">
                                    <label class="cbx" for="auth_remind">
                                        <span>
                                            <svg width="12px" height="9px" viewbox="0 0 12 9">
                                                <polyline points="1 5 4 8 11 1"></polyline>
                                            </svg>
                                        </span>
                                        <span>{{ __('I agree with') }} <a class="link" href="{{ url('/privacy-policy') }}"> Privacy Policy </a> and <a href="{{ url('/terms-and-conditions') }}"> {{ __('Terms & Condition') }} </a></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-xxl-12">
                                <div class="auth-from-btn-wrap mt-5">
                                    <button class="site-btn primary-btn w-100" type="submit" form="signUpForm">{{ __('Create Account') }}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="auth-from-bottom-content">
                    <div class="auth-account">
                        <p class="description">{{ __('Already have an account?') }} <a class="link" href="{{ route('login') }}"> {{ __('Login') }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Sign up area end -->

@endsection
@section('script')
@if($googleReCaptcha)
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endif
<script>
    $('#countrySelect').on('change', function(e) {
        "use strict";
        e.preventDefault();
        var country = $(this).val();
        $('#dial-code').html(country.split(":")[1])
    })
</script>


<script>
    $(document).ready(function() {
        $('.eyeicon').on('click', function() {
            let passwordInput = $(this).siblings('.password-input');
            let icon = $(this).find('i');

            if (passwordInput.attr('type') === 'password') {
                passwordInput.attr('type', 'text');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            } else {
                passwordInput.attr('type', 'password');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            }
        });
    });
</script>
@endsection