@extends('frontend::layouts.auth')

@section('title')
{{ __('Login') }}
@endsection
@section('content')

<!-- Sign in area start -->
<div class="sign-in-area">
   <div class="auth-inner">
      <div class="auth-wrapper">
         <div class="auth-from-inner">
            <div class="auth-from-top-content">
               <div class="auth-logo">
                  <a href="{{ route('home') }}">
                     <img src="{{ asset(setting('site_logo','global')) }}" alt="logo" alt="logo">
                  </a>
               </div>

               <h3 class="title">{{ $data['title'] }}</h3>
               <p class="description">{{ $data['bottom_text'] }}</p>
            </div>
            <div class="auth-from-box">
               @if ($errors->any())
               <div class="alert alert-warning alert-dismissible fade show" role="alert">
                  @foreach($errors->all() as $error)
                  <strong>{{$error}}</strong>
                  @endforeach
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
               </div>
               @endif
               <form action="{{ route('login') }}" method="POST" id="loginForm">
                  @csrf
                  <div class="coinefy-single-input has-right-icon mb-25">
                     <div class="input-field">
                        <input type="email" name="email" class="box-input" placeholder="Enter username or email" required>
                        <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                     </div>
                     <p class="feedback-invalid">This field is required</p>
                  </div>
                  <div class="coinefy-single-input has-right-icon mb-25">
                     <div class="input-field">
                        <input type="password" name="password" class="box-input password-input" placeholder="Password" required>
                        <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                     </div>
                     <p class="feedback-invalid">This field is required</p>
                  </div>
                  @if($googleReCaptcha)
                  <div class="g-recaptcha mb-3" id="feedback-recaptcha" data-sitekey="{{ json_decode($googleReCaptcha->data,true)['google_recaptcha_key'] }}">
                  </div>
                  @endif
                  <div class="auth-login-option">
                     <div class="animate-custom">
                        <input class="inp-cbx" id="auth_remind" type="checkbox" style="display: none;">
                        <label class="cbx" for="auth_remind">
                           <span>
                              <svg width="12px" height="9px" viewbox="0 0 12 9">
                                 <polyline points="1 5 4 8 11 1"></polyline>
                              </svg>
                           </span>
                           <span>{{ __('Remember me') }}</span>
                        </label>
                     </div>
                     @if (Route::has('password.request'))
                     <div class="forget-content">
                        <span><a href="{{ route('password.request') }}">{{ __('Forget Password') }}</a></span>
                     </div>
                     @endif
                  </div>
                  <div class="auth-from-btn-wrap">
                     <button class="site-btn primary-btn w-100" form="loginForm" type="submit">{{ __('Account Login') }}</button>
                  </div>
               </form>
            </div>
            <div class="auth-from-bottom-content">
               <div class="auth-account">
                  <p class="description"> {{ __("Don't have an account?") }}<a class="link" href="{{route('register')}}"> {{ __('Signup for free') }}</a></p>
               </div>
               <div class="auth-privacy-policy">
                  <p class="description">{{__("By clicking Login, you agree to our")}} <a class="link" href="{{ url('/terms-and-conditions') }}"> Terms & Condition</a> <span>and</span> <a class="link" href="{{url('/privacy-policy')}}"> Privacy Policy</a></p>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- Sign in area end -->

@endsection
@section('script')
@if($googleReCaptcha)
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endif
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
   $(document).ready(function() {
      $('.eyeicon').on('click', function() {
         let passwordInput = $(this).siblings('.password-input');
         let icon = $(this).find('i');

         if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
         } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
         }
      });
   });
</script>