<div class="tab-pane fade {{ request()->get('tab') === 'tickets' ? 'show active' : '' }}" id="pills-ticket" role="tabpanel" aria-labelledby="pills-ticket-tab">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title">{{ __('Support Tickets') }}</h4>
                </div>
                <div class="site-card-body table-responsive">
                    <div class="site-datatable">
                        <table class="display data-table">
                            <thead>
                            <tr>
                                <th>{{ __('Ticket Name') }}</th>
                                <th>{{ __('Opening Date') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($tickets as $ticket)
                                <tr>
                                    <td>@include('backend.ticket.include.__name', ['ticket' => $ticket])</td>
                                    <td>{{ $ticket->created_at }}</td>
                                    <td>@include('backend.ticket.include.__status', ['ticket' => $ticket])</td>
                                    <td>@include('backend.ticket.include.__action', ['ticket' => $ticket])</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        @if ($tickets->isEmpty())
                            <p>{{ __('No tickets found.') }}</p>
                        @endif
                        {{ $tickets->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>