<div class="tab-pane fade {{ request()->get('tab') === 'earnings' ? 'show active' : '' }}" id="pills-deposit" role="tabpanel" aria-labelledby="pills-deposit-tab">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h4 class="title">{{ __('Earnings') }}</h4>
                    <div class="card-header-info">{{ __('Total Earnings:') }} {{ $user->totalProfit() }} {{ $currency }}</div>
                </div>
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="site-table table-responsive">
                                <form action="{{ request()->url() }}" method="get">
                                    <div class="table-filter">
                                        <div class="filter">
                                        </div>
                                    <!-- <div class="filter d-flex">
                                            <div class="search">
                                                <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                            </div>
                                            <button type="submit" class="apply-btn"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                        </div> -->
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('Date') }}</th>
                                        <th scope="col">{{__('User')}}</th>
                                        <th scope="col">{{__('Amount') }}</th>
                                        <th scope="col">{{__('Type') }}</th>
                                        <th scope="col">{{__('Profit From') }}</th>
                                        <th scope="col">{{__('Description') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($data as $item)
                                        <tr>
                                            <td>{{ $item->created_at }}</td>
                                            <td>@include('backend.transaction.include.__user', ['item' => $item])</td>
                                            <td>@include('backend.transaction.include.__txn_amount', ['item' => $item])</td>
                                            <td>@include('backend.transaction.include.__txn_type', ['item' => $item])</td>
                                            <td>{{ $item->from_user_id != null ? \App\Models\User::find($item->from_user_id)->username : 'System' }}</td>
                                            <td>{{ $item->description }}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                @if ($data->isEmpty())
                                    <p>{{ __('No Earnings found.') }}</p>
                                @endif
                                {{ $data->links('backend.include.__pagination') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@push('single-script')
    <script>
        (function($) {
            "use strict";

            var table = $('#user-profit-dataTable').DataTable({
                processing: true,
                serverSide: true,
                autoWidth: false,
                ajax: "{{ route('admin.all-profits',$user->id) }}",
                columns: [{
                    data: 'created_at',
                    name: 'created_at'
                },
                    {
                        data: 'final_amount',
                        name: 'final_amount'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'profit_from',
                        name: 'profit_from'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },

                ]
            });


        })(jQuery);
    </script>
@endpush