@extends('backend.layouts.app')
@section('title')
    {{ __('All Support Tickets') }}
@endsection

@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title">{{ __($title) }}</h2>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                            </div>
                        </form>
                        <div class="site-datatable">
                            <table id="dataTable" class="display data-table">
                                <thead>
                                <tr>
                                    <th>{{ __('Ticket Name') }}</th>
                                    <th>{{ __('Opening Date') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse ($tickets as $ticket)
                                    <tr>
                                        <td>@include('backend.ticket.include.__name', ['ticket' => $ticket])</td>
                                        <td>{{ $ticket->created_at }}</td>
                                        <td>@include('backend.ticket.include.__status', ['ticket' => $ticket])</td>
                                        <td>@include('backend.ticket.include.__action', ['ticket' => $ticket])</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">{{ __('No Data Found!') }}</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                            {{ $tickets->links('backend.include.__pagination') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection