@extends('backend.layouts.app')
@section('title')
    {{ __('Edit Schema') }}
@endsection
@section('style')
    <link rel="stylesheet" href="{{ asset('backend/css/choices.min.css') }}">
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-8">
                        <div class="title-content">
                            <h2 class="title">{{ __('Edit Schema') }}</h2>
                            <a href="{{ url()->previous() }}" class="title-btn"><i
                                        icon-name="corner-down-left"></i>{{ __('Back') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-12 col-md-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <form action="{{route('admin.schema.update',$schema->id)}}" method="post"
                                  enctype="multipart/form-data" class="row">
                                @method('PUT')
                                @csrf
                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="col-xl-3">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Upload Icon:') }}</label>
                                                <div class="wrap-custom-file">
                                                    <input
                                                            type="file"
                                                            name="icon"
                                                            id="schema-icon"
                                                            accept=".gif, .jpg, .png"
                                                    />
                                                    <label for="schema-icon" class="file-ok"
                                                           style="background-image: url({{ asset($schema->icon) }})">
                                                        <img
                                                                class="upload-icon"
                                                                src="{{ asset('global/materials/upload.svg')}}"
                                                                alt=""
                                                        />
                                                        <span>{{ __('Update Avatar') }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="schema-name @if($schema->featured) col-xl-6 @else col-xl-12 @endif">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Name:') }}</label>
                                        <input
                                                type="text"
                                                name="name"
                                                value="{{$schema->name}}"
                                                class="box-input"
                                                placeholder="Investment Plan name"
                                                required
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6 schema-badge @if(!$schema->featured) hidden @endif">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Badge:') }}</label>
                                        <input
                                                type="text"
                                                class="box-input"
                                                placeholder="Schema Badge"
                                                name="badge"
                                                value="{{$schema->badge}}"
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="fixed-type"
                                                    name="schema_type"
                                                    value="fixed"
                                                    @if($schema->type == 'fixed') checked @endif
                                            />
                                            <label for="fixed-type">{{ __('Fixed') }}</label>
                                            <input
                                                    type="radio"
                                                    id="range-type"
                                                    name="schema_type"
                                                    value="range"
                                                    @if($schema->type == 'range') checked @endif
                                            />
                                            <label for="range-type">{{ __('Range') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups row">
                                        <div class="col-xl-6 min-amount @if($schema->type == 'fixed') hidden @endif">
                                            <label class="box-input-label" for="">{{ __('Min Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_min_amount" value="{{ $schema->min_amount }}"
                                                       oninput="this.value = validateDouble(this.value)"
                                                       class="form-control" required/>
                                                <span
                                                        class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 max-amount @if($schema->type == 'fixed') hidden @endif">
                                            <label class="box-input-label" for="">{{ __('Max Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_max_amount" value="{{ $schema->max_amount }}"
                                                       oninput="this.value = validateDouble(this.value)"
                                                       class="form-control" required/>
                                                <span
                                                        class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>

                                        <div class="col-xl-12 fixed-amount @if($schema->type == 'range') hidden @endif">
                                            <label class="box-input-label" for="">{{ __('Amount:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="schema_fixed_amount"
                                                       value="{{ $schema->fixed_amount }}"
                                                       oninput="this.value = validateDouble(this.value)"
                                                       class="form-control"/>
                                                <span
                                                        class="input-group-text">{{ setting('site_currency','global') }}</span>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('ROI Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="roi-fixed-type"
                                                    name="roi_type"
                                                    value="fixed"
                                                    @if($schema->interest_type == 'fixed') checked @endif
                                            />
                                            <label for="roi-fixed-type">{{ __('Fixed') }}</label>
                                            <input
                                                    type="radio"
                                                    id="roi-range-type"
                                                    name="roi_type"
                                                    value="range"
                                                    @if($schema->interest_type == 'range') checked @endif
                                            />
                                            <label for="roi-range-type">{{ __('Range') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups row">
                                        <div class="col-xl-6 roi-min-amount">
                                            <label class="box-input-label" for="">{{ __('Min:') }}</label>
                                            <div class="input-group joint-input">
                                                <input type="text" name="roi_min_amount" oninput="this.value = validateDouble(this.value)" class="form-control" required value="{{ $schema->min_roi }}" />
                                            </div>
                                        </div>
                                        <div class="col-xl-6 roi-max-amount">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Max:') }}</label>
                                                <div class="position-relative">
                                                    <input type="text" class="box-input" name="roi_max_amount" value="{{ $schema->max_roi }}" oninput="this.value = validateDouble(this.value)" required />
                                                    <div class="prcntcurr">
                                                        <select name="roi_interest_type_range" class="form-select" id="">
                                                            <option value="percentage"
                                                                    @if($schema->roi_interest_type == 'percentage') selected @endif>{{ __('%') }}</option>
                                                            <option value="fixed"
                                                                    @if($schema->roi_interest_type == 'fixed') selected @endif>{{ $currencySymbol }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="col-xl-12 roi-fixed-amount @if($schema->interest_type != 'fixed') hidden @endif">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Fixed Interest Amount:') }}</label>
                                                <div class="position-relative">
                                                    <input type="text" class="box-input" name="roi_fixed_amount" value="{{ $schema->fixed_roi }}" oninput="this.value = validateDouble(this.value)" required />
                                                    <div class="prcntcurr">
                                                        <select name="roi_interest_type_fixed" class="form-select" id="">
                                                            <option value="percentage"
                                                                    @if($schema->roi_interest_type == 'percentage') selected @endif>{{ __('%') }}</option>
                                                            <option value="fixed"
                                                                    @if($schema->roi_interest_type == 'fixed') selected @endif>{{ $currencySymbol }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Return Period:') }}</label>
                                        <select name="return_period" class="form-select" id="">
                                            @foreach($schedules as $schedule)
                                                <option value="{{$schedule->id}}"
                                                        @if($schema->return_period == $schedule->id) selected @endif>{{$schedule->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Return Type:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="return-type-period"
                                                    name="return_type"
                                                    value="period"
                                                    @if($schema->return_type == 'period') checked @endif
                                            />
                                            <label for="return-type-period">{{ __('Period') }}</label>
                                            <input
                                                    type="radio"
                                                    id="return-type-lifetime"
                                                    name="return_type"
                                                    @if($schema->return_type == 'lifetime') checked @endif
                                                    value="lifetime"
                                            />
                                            <label for="return-type-lifetime">{{ __('Lifetime') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 number-period @if($schema->return_type == 'lifetime') hidden @endif">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Number of Period:') }}</label>
                                        <div class="input-group joint-input">
                                            <input
                                                    type="text"
                                                    name="number_of_period"
                                                    value="{{$schema->number_of_period}}"
                                                    onkeypress="return validateNumber(event)"
                                                    class="form-control"
                                                    placeholder="Total Repeat Time"
                                                    required
                                            />
                                            <span class="input-group-text">{{ __('Times') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for="">{{ __('Profit Return Custom Holiday (If you put any day here, user will never get the profit on that date):') }}</label>
                                        <select id="choices-multiple-remove-button" name="off_days[]"
                                                placeholder="Manage Days" multiple>
                                            @foreach($offDaySchedule as $day)
                                                @php
                                                    $storedOffDays = is_array($schema->off_days) ? $schema->off_days : json_decode($schema->off_days, true);
                                                @endphp
                                                <option value="{{ $day }}"
                                                        @selected(is_array($storedOffDays) && in_array($day, $storedOffDays))>
                                                    {{ $day }}
                                                </option>
                                            @endforeach
                                            @foreach($holidays as $holiday)
                                                @php
                                                    $holidayName = $holiday->name;
                                                @endphp
                                                <option value="{{ $holiday->date }}"
                                                        @selected(is_array($storedOffDays) && in_array($holidayName, $storedOffDays))>
                                                    {{ $holidayName }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Capital Back:') }}</label>
                                                <div class="switch-field same-type">
                                                    <input
                                                            type="radio"
                                                            id="radio-seven"
                                                            name="capital_back"
                                                            value="1"
                                                            @if($schema->capital_back) checked @endif
                                                    />
                                                    <label for="radio-seven">{{ __('Yes') }}</label>
                                                    <input
                                                            type="radio"
                                                            id="radio-eight"
                                                            name="capital_back"
                                                            value="0"
                                                            @if(!$schema->capital_back) checked @endif
                                                    />
                                                    <label for="radio-eight">{{ __('No') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
                                            <div class="site-input-groups">
                                                <label class="box-input-label" for="">{{ __('Featured:') }}</label>
                                                <div class="switch-field same-type">
                                                    <input
                                                            type="radio"
                                                            id="featured-yes"
                                                            name="featured"
                                                            value="1"
                                                            @if($schema->featured) checked @endif
                                                    />
                                                    <label for="featured-yes">{{ __('Yes') }}</label>
                                                    <input
                                                            type="radio"
                                                            id="featured-no"
                                                            name="featured"
                                                            value="0"
                                                            @if(!$schema->featured) checked @endif
                                                    />
                                                    <label for="featured-no">{{ __('No') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-xl-6 schema-cancel">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Cancel:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="schema-cancel-yes"
                                                    name="schema_cancel"
                                                    value="1"
                                                    @checked($schema->schema_cancel)

                                            />
                                            <label for="schema-cancel-yes">{{ __('Yes') }}</label>
                                            <input
                                                    type="radio"
                                                    id="schema-cancel-no"
                                                    name="schema_cancel"
                                                    value="0"
                                                    @checked(!$schema->schema_cancel)
                                            />
                                            <label for="schema-cancel-no">{{ __('No') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 cancel-expiry  @if(!$schema->schema_cancel) hidden @endif">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for="">{{ __('Cancel Expiry') .' (Max 59 Minutes):' }}</label>
                                        <div class="input-group joint-input">
                                            <input type="text" name="expiry_minute"
                                                   onkeypress="return validateNumber(event)"
                                                   value="{{ $schema->expiry_minute }}"
                                                   class="form-control"/>
                                            <span
                                                    class="input-group-text">{{ __('Minute') }}</span>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Schema Trending:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="schema-trending-yes"
                                                    name="is_trending"
                                                    @checked($schema->is_trending)
                                            value="1"
                                            />
                                            <label for="schema-trending-yes">{{ __('Yes') }}</label>
                                            <input
                                                    type="radio"
                                                    id="schema-trending-no"
                                                    name="is_trending"
                                                    @checked(!$schema->is_trending)
                                            value="0"
                                            />
                                            <label for="schema-trending-no">{{ __('No') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Status:') }}</label>
                                        <div class="switch-field same-type">
                                            <input
                                                    type="radio"
                                                    id="radio-five"
                                                    name="status"
                                                    checked=""
                                                    value="1"
                                                    @checked($schema->status)
                                            />
                                            <label for="radio-five">{{ __('Active') }}</label>
                                            <input
                                                    type="radio"
                                                    id="radio-six"
                                                    name="status"
                                                    value="0"
                                                    @checked(!$schema->status)
                                            />
                                            <label for="radio-six">{{ __('Deactivate') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <button type="submit" class="site-btn-sm primary-btn w-100">
                                        {{ __('Update Schema') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script src="{{ asset('backend/js/choices.min.js') }}"></script>
    <script>
        $("#fixed-type").on('click', function () {
            $("input[name='fixed_amount']").prop('required', true);
            $("input[name='min_amount']").removeAttr('required');
            $("input[name='max_amount']").removeAttr('required');

            $(".min-amount").addClass('hidden');
            $(".max-amount").addClass('hidden');
            $(".fixed-amount").removeClass('hidden');
        });
        $("#range-type").on('click', function () {
            $("input[name='fixed_amount']").removeAttr('required');
            $("input[name='min_amount']").prop('required', true);
            $("input[name='max_amount']").prop('required', true);

            $(".fixed-amount").addClass('hidden');
            $(".min-amount").removeClass('hidden');
            $(".max-amount").removeClass('hidden');
        });

        $("#featured-no").on('click', function () {
            $("input[name='badge']").removeAttr('required');
            var schemaName = $(".schema-name");
            $(".schema-badge").addClass('hidden');
            schemaName.removeClass('col-xl-6');
            schemaName.addClass('col-xl-12');

        });
        $("#featured-yes").on('click', function () {
            $("input[name='badge']").prop('required', true);
            var schemaName = $(".schema-name");
            $(".schema-badge").removeClass('hidden');
            schemaName.removeClass('col-xl-12');
            schemaName.addClass('col-xl-6');
        });

        $("#schema-cancel-yes").on('click', function () {
            $("input[name='expiry_minute']").prop('required', true);
            $(".cancel-expiry").removeClass('hidden');
        });

        $("#schema-cancel-no").on('click', function () {
            $("input[name='expiry_minute']").removeAttr('required');
            $(".cancel-expiry").addClass('hidden');
        });


        $("#return-type-period").on('click', function () {
            $("input[name='number_of_period']").prop('required', true);
            $(".number-period").removeClass('hidden');
        });

        $("#return-type-lifetime").on('click', function () {
            $("input[name='number_of_period']").removeAttr('required');
            $(".number-period").addClass('hidden');
        });





        // Show fields based on interest type
        $("#roi_type").on('click', function () {
            // Show Min and Max Percentage fields
            $(".min-max-percentage").removeClass('hidden');
            // Hide Fixed Amount field
            $(".fixed-interest-amount").addClass('hidden');
            // Make Percentage fields required
            $("input[name='min_roi']").prop('required', true);
            $("input[name='max_percentage']").prop('required', true);
            // Remove required attribute from Fixed Amount field
            $("input[name='fixed_interest_amount']").removeAttr('required');
        });

        $("#fixed-interest-type").on('click', function () {
            // Show Fixed Amount field
            $(".fixed-interest-amount").removeClass('hidden');
            // Hide Min and Max Percentage fields
            $(".min-max-percentage").addClass('hidden');
            // Make Fixed Amount field required
            $("input[name='fixed_interest_amount']").prop('required', true);
            // Remove required attribute from Percentage fields
            $("input[name='min_percentage']").removeAttr('required');
            $("input[name='max_percentage']").removeAttr('required');
        });

        // Trigger the click event on page load to set the initial state
        $("#percentage-type").trigger('click');


        function toggleInterestFields() {
            if ($("#roi-fixed-type").is(":checked")) {
                $(".roi-fixed-amount").removeClass('hidden');
                $(".roi-min-amount, .roi-max-amount").addClass('hidden');
                $("input[name='roi_fixed_amount']").prop('required', true);
                $("input[name='roi_min_amount']").removeAttr('required');
                $("input[name='roi_max_amount']").removeAttr('required');
            } else if ($("#roi-range-type").is(":checked")) {
                $(".roi-fixed-amount").addClass('hidden');
                $(".roi-min-amount, .roi-max-amount").removeClass('hidden');
                $("input[name='roi_fixed_amount']").removeAttr('required');
                $("input[name='roi_min_amount']").prop('required', true);
                $("input[name='roi_max_amount']").prop('required', true);
            }
        }

        toggleInterestFields();

        $("#roi-fixed-type, #roi-range-type").on('change', function () {
            toggleInterestFields();
        });


        var multipleCancelButton = new Choices('#choices-multiple-remove-button', {
            removeItemButton: true,
            maxItemCount: 7,
            searchResultLimit: 7,
            renderChoiceLimit: 7
        });

    </script>
@endsection
