@extends('backend.layouts.app')
@section('title')
    {{ __('Investments') }}
@endsection
@section('style')
    <script src="{{ asset('global/js/jquery.min.js') }}"></script>
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title">{{$title}}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="site-card">
                <div class="site-card-body">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                                <div class="filter d-flex">
                                    <select class="form-select form-select-sm me-2" name="filter_by_schema" aria-label=".form-select-sm example">
                                        <option value="" selected>{{ __('Filter By Schema') }}</option>
                                        @foreach($schemas as $schema)
                                            <option value="{{ $schema->id }}" {{ request('filter_by_schema') == $schema->id ? 'selected' : '' }}>{{ __($schema->name) }}</option>
                                        @endforeach
                                    </select>
                                    <select class="form-select form-select-sm" name="status" aria-label=".form-select-sm example">
                                        <option value="" selected>{{ __('Filter By Capital Back') }}</option>
                                        <option value="1" {{ request('status') == '1' ? 'selected' : '' }}>{{ __('Yes') }}</option>
                                        <option value="0" {{ request('status') == '0' ? 'selected' : '' }}>{{ __('No') }}</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th>{{ __('Icon') }}</th>
                                <th>{{ __('User') }}</th>
                                <th>{{ __('Schema') }}</th>
                                <th>{{ __('ROI') }}</th>
                                <th>{{ __('Profit') }}</th>
                                <th>{{ __('Capital Back') }}</th>
                                <th>{{ __('Period Remaining') }}</th>
                                <th>{{ __('Timeline') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($data as $item)
                                <tr>
                                    <td>@include('backend.investment.include.__invest_icon', ['item' => $item])</td>
                                    <td>@include('backend.transaction.include.__user', ['item' => $item])</td>
                                    <td>@include('backend.investment.include.__invest_schema', ['item' => $item])</td>
                                    <td>@include('backend.investment.include.__invest_rio', ['item' => $item])</td>
                                    <td>@include('backend.investment.include.__invest_profit', ['item' => $item])</td>
                                    <td>@include('backend.investment.include.__invest_capital_back', ['item' => $item])</td>
                                    <td>
                                        @if ($item->return_type != 'period')
                                            Unlimited
                                        @else
                                            {{ $item->number_of_period }} {{ $item->number_of_period < 2 ? 'Time' : 'Times' }}
                                        @endif
                                    </td>
                                    <td>@include('backend.investment.include.__invest_next_profit_time', ['item' => $item])</td>

                                </tr>
                            @empty
                                <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                            @endforelse
                            </tbody>
                        </table>
                        {{ $data->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection