@extends('backend.layouts.app')
@section('title')
    {{ __('Holidays') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title">{{ __('All Holidays') }}</h2>
                            <a
                                    href=""
                                    class="title-btn"
                                    type="button"
                                    data-bs-toggle="modal"
                                    data-bs-target="#addNewSchedule"
                            ><i icon-name="plus-circle"></i>{{ __('Add New') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('#') }}</th>
                                        <th scope="col">{{ __('Name') }}</th>
                                        <th scope="col">{{ __('Date') }}</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($holidays as $holiday)
                                        <tr>
                                            <td>{{++$loop->index}}</td>
                                            <td>{{$holiday->name}}</td>
                                            <td>
                                                <strong>{{$holiday->date}}</strong>
                                            </td>
                                            <td>
                                                <button
                                                        class="round-icon-btn primary-btn"
                                                        type="button"
                                                        id="edit"
                                                        data-id="{{$holiday->id}}"
                                                >
                                                    <i icon-name="edit-3"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New Schedule -->
    @include('backend.holiday.modal.__new_holiday')
    <!-- Modal for Add New Schedule-->

        <!-- Modal for Edit Schedule -->
    @include('backend.holiday.modal.__edit_holiday')
    <!-- Modal for Edit Schedule-->

    </div>
@endsection

@section('script')
    <script>

        $('body').on('click', '#edit', function (event) {
            "use strict";
            event.preventDefault();
            var id = $(this).data('id');
            $.get('holiday/' + id + '/edit', function (data) {

                var url = '{{ route("admin.holiday.update", ":id") }}';
                url = url.replace(':id', id);
                $('#editForm').attr('action', url)
                $('#editModal').modal('show');

                $('#name').val(data.name);
                $('#time').val(data.date);
                // if (data.time <= 1) {
                //     $('#time-level').html('Hour');
                // } else {
                //     $('#time-level').html('Hours');
                // }
            })
        });

    </script>
@endsection
