@extends('backend.deposit.index')
@section('title')
    {{ __('Deposit History') }}
@endsection
@section('deposit_content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="site-table table-responsive">
                    <form action="{{ request()->url() }}" method="get">
                        <div class="table-filter d-flex justify-content-between">
                            <div class="filter d-flex">
                                <div class="search">
                                    <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                </div>
                                <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                            </div>
                            <div class="filter d-flex">
                                <select class="form-select form-select-sm" name="status" aria-label=".form-select-sm example">
                                    <option value="" selected>{{ __('Filter By Status') }}</option>
                                    <option value="success" {{ request('status') == 'success' ? 'selected' : '' }}>{{ __('Success') }}</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pending') }}</option>
                                    <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>{{ __('Failed') }}</option>
                                </select>
                            </div>
                        </div>
                    </form>
                    <table class="table">
                        <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('User') }}</th>
                            <th>{{ __('Transaction ID') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Charge') }}</th>
                            <th>{{ __('Gateway') }}</th>
                            <th>{{ __('Status') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($histories as $history)
                            <tr>
                                <td>{{ $history->created_at }}</td>
                                <td>@include('backend.transaction.include.__user', ['item' => $history])</td>
                                <td>{{ $history->tnx}}</td>
                                <td>@include('backend.transaction.include.__txn_amount', ['item' => $history])</td>
                                <td>{{ $history->charge . ' ' . setting('site_currency', 'global') }}</td>
                                <td>{{$history->method}}</td>
                                <td>@include('backend.transaction.include.__txn_status', ['status' => $history->status])</td>
                            </tr>
                        @empty
                            <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                        @endforelse
                        </tbody>
                    </table>
                    {{ $histories->links('backend.include.__pagination') }}
                </div>
            </div>
        </div>
    </div>


@endsection