<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use DataTables;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class TransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function __construct()
    {
        $this->middleware('permission:transaction-list');

    }

    /**
     * @return Application|Factory|View|JsonResponse
     *
     * @throws \Exception
     */
    public function transactions(Request $request, $id = null)
    {
        $search = $request->query('query') ?? null;
        $transactionType = $request->query('filter_by_transaction_type') ?? null;
        $status = $request->query('status') ?? null;

        $data = Transaction::query()
            ->when($search, function ($query, $search) {
                $query->search($search);
            })
            ->when($transactionType, function ($query, $transactionType) {
                $query->where('type', $transactionType);
            })
            ->when($status, function ($query, $status) {
                $query->where('status', $status);
            })
            ->latest()
            ->paginate(10);

        $title = "All Transactions";
        return view('backend.transaction.index', compact('data', 'title'));
    }
}
